<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\Webhook;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the Webhook
 * endpoints of the API
 *
 * @method list()
 * @method get()
 * @method retry()
 */
class WebhooksService extends BaseService
{

    protected $envelope_key   = 'webhooks';
    protected $resource_class = '\GoCardlessPro\Resources\Webhook';


    /**
     * List webhooks
     *
     * Example URL: /webhooks
     *
     * @param  string[mixed] $params An associative array for any params
     * @return ListResponse
     **/
    protected function _doList($params = array())
    {
        $path = "/webhooks";
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Get a single webhook
     *
     * Example URL: /webhooks/:identity
     *
     * @param  string        $identity Unique identifier, beginning with "WB".
     * @param  string[mixed] $params   An associative array for any params
     * @return Webhook
     **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/webhooks/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
     * Retry a webhook
     *
     * Example URL: /webhooks/:identity/actions/retry
     *
     * @param  string        $identity Unique identifier, beginning with "WB".
     * @param  string[mixed] $params   An associative array for any params
     * @return Webhook
     **/
    public function retry($identity, $params = array())
    {
        $path = Util::subUrl(
            '/webhooks/:identity/actions/retry',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array("data" => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                if ($this->api_client->error_on_idempotency_conflict) {
                    throw $e;
                }
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
     * List webhooks
     *
     * Example URL: /webhooks
     *
     * @param  string[mixed] $params
     * @return Paginator
     **/
    public function all($params = array())
    {
        return new Paginator($this, $params);
    }

}
