<?php $__env->startSection('meta_title', ctrans('texts.payment')); ?>

<?php $__env->startSection('body'); ?>
    <div class="container mx-auto">
        <div class="overflow-hidden bg-white shadow sm:rounded-lg">
            <div class="px-4 py-5 border-b border-gray-200 sm:px-6">
                <h3 class="text-lg font-medium leading-6 text-gray-900">
                    <?php echo e(ctrans('texts.payment')); ?>

                </h3>
                <p class="max-w-2xl mt-1 text-sm leading-5 text-gray-500" translate>
                    <?php echo e(ctrans('texts.payment_details')); ?>

                </p>
            </div>
            <div>
                <dl>
                    <?php if(!empty($payment->clientPaymentDate()) && !is_null($payment->clientPaymentDate())): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.payment_date')); ?>

                            </dt>
                            <dd class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <?php echo e($payment->clientPaymentDate()); ?>

                            </dd>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($payment->number) && !is_null($payment->number)): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.number')); ?>

                            </dt>
                            <dd class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <?php echo e($payment->number); ?>

                            </dd>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($payment->transaction_reference) && !is_null($payment->transaction_reference)): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.transaction_reference')); ?>

                            </dt>
                            <dd class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                        <span class="break-all">
                            <?php echo e($payment->transaction_reference); ?>

                        </span>
                            </dd>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($payment->type?->name) && !is_null($payment->type?->name)): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.method')); ?>

                            </dt>
                            <dd class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <?php echo e($payment->type?->name); ?>

                            </dd>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($payment->formattedAmount()) && !is_null($payment->formattedAmount())): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.amount')); ?>

                            </dt>
                            <dd class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <?php echo e($payment->formatAmount($payment->amount > 0 ? $payment->amount : $payment?->invoices->sum('pivot.amount'))); ?>

                            </dd>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($payment->status_id) && !is_null($payment->status_id)): ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.status')); ?>

                            </dt>
                            <div class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <?php echo \App\Models\Payment::badgeForStatus($payment->status_id); ?>

                            </div>
                        </div>

                        <?php if($payment->refunded > 0): ?>
                            <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium leading-5 text-gray-500">
                                    <?php echo e(ctrans('texts.refunded')); ?>

                                </dt>
                                <div class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                    <?php echo e(\App\Utils\Number::formatMoney($payment->refunded, $payment->client)); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </dl>
            </div>
        </div>
        <div class="mt-4 overflow-hidden bg-white shadow sm:rounded-lg">
            <div class="px-4 py-5 border-b border-gray-200 sm:px-6">
                <h3 class="text-lg font-medium leading-6 text-gray-900">
                    <?php echo e(ctrans('texts.invoices')); ?>

                </h3>
                <p class="max-w-2xl mt-1 text-sm leading-5 text-gray-500">
                    <?php echo e(ctrans('texts.list_of_payment_invoices')); ?>

                </p>
            </div>
            <div>
                <dl>
                    <?php $__currentLoopData = $payment->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="px-4 py-5 bg-white sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                            <dt class="text-sm font-medium leading-5 text-gray-500">
                                <?php echo e(ctrans('texts.invoice_number')); ?>

                            </dt>
                            <div class="mt-1 text-sm leading-5 text-gray-900 sm:mt-0 sm:col-span-2">
                                <a class="button-link text-primary"
                                   href="<?php echo e(route('client.invoice.show', ['invoice' => $invoice->hashed_id])); ?>">
                                    <?php echo e($invoice->number); ?>

                                </a>
                                - <?php echo e(\App\Utils\Number::formatMoney($payment->invoices->where('id', $invoice->id)->sum('pivot.amount') - $payment->invoices->where('id', $invoice->id)->sum('pivot.refunded'), $payment->client)); ?>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </dl>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('portal.ninja2020.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/unihit/public_html/betaling/resources/views/portal/ninja2020/payments/show.blade.php ENDPATH**/ ?>