<?php $__env->startSection('meta_title', $title); ?>

<?php $__env->startSection('body'); ?>
    <div class="grid lg:grid-cols-3">
        <?php if($account && !$account->isPaid()): ?>
        <div class="hidden lg:block col-span-1 bg-red-100 h-screen">
            <img src="<?php echo e(asset('images/client-portal-new-image.jpg')); ?>"
                 class="w-full h-screen object-cover"
                 alt="Background image">
        </div>
        <?php endif; ?>
        <div class="<?php echo e($account && !$account->isPaid() ? 'col-span-2' : 'col-span-3'); ?> h-screen flex">
            <div class="m-auto w-1/2 md:w-1/3 lg:w-1/4">
                <?php if($account && !$account->isPaid()): ?>
                    <div>
                        <img src="<?php echo e(asset('images/invoiceninja-black-logo-2.png')); ?>" class="border-b border-gray-100 h-18 pb-4" alt="Invoice Ninja logo">
                    </div>
                <?php elseif(isset($company) && !is_null($company)): ?>
                    <div>
                        <img src="<?php echo e(asset($company->present()->logo())); ?>" class="h-14 mb-10" alt="<?php echo e($company->present()->name()); ?> logo">
                    </div>
                <?php endif; ?>
                <div class="flex flex-col">
                    <h1 class="text-center text-3xl"><?php echo e(ctrans('texts.password_recovery')); ?></h1>
                    <p class="text-center mt-1 text-gray-600"><?php echo e(ctrans('texts.reset_password_text')); ?></p>
                    <?php if(session('status')): ?>
                        <div class="alert alert-success mt-4">
                            <?php echo e(session('status')); ?>

                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(route($passwordEmailRoute)); ?>" method="post" class="mt-6">
                        <?php echo csrf_field(); ?>
                        <div class="flex flex-col">
                            <label for="email" class="input-label"><?php echo e(ctrans('texts.email_address')); ?></label>
                            <?php if($company && !is_null($company)): ?>
                            <input type="hidden" name="company_key" value="<?php echo e($company->company_key); ?>">
                            <?php endif; ?>
                            <input type="email" name="email" id="email"
                                   class="input"
                                   value="<?php echo e(request()->query('email') ?? old('email')); ?>"
                                   autofocus
                                   required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="validation validation-fail">
                                <?php echo e($message); ?>

                            </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mt-5">
                            <button class="button button-primary button-block bg-blue-600"><?php echo e(ctrans('texts.next_step')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('portal.ninja2020.layout.clean', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/unihit/public_html/betaling/resources/views/portal/ninja2020/auth/passwords/request.blade.php ENDPATH**/ ?>