<div>
    <?php if (! (count($methods) == 0)): ?>
        <div x-data="{ open: false }" @keydown.window.escape="open = false" @click.away="open = false"
             class="relative inline-block text-left" dusk="payment-methods-dropdown">
            <div>
                <div class="rounded-md shadow-sm">
                    <button dusk="pay-now-dropdown" @click="open = !open" type="button"
                            class="button button-primary bg-primary hover:bg-primary-darken inline-flex items-center">
                        <?php echo e(ctrans('texts.pay_now')); ?>

                        <svg class="w-5 h-5 ml-2 -mr-1" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                  d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                  clip-rule="evenodd"/>
                        </svg>
                    </button>
                </div>
            </div>
            <div x-show="open" class="absolute right-0 w-56 mt-2 origin-top-right rounded-md shadow-lg">
                <div class="bg-white rounded-md ring-1 ring-black ring-opacity-5">
                    <div class="py-1">
                        <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($method['label'] == 'Custom'): ?>
                                <a href="#" @click="{ open = false }" dusk="pay-with-custom"
                                   data-company-gateway-id="<?php echo e($method['company_gateway_id']); ?>"
                                   data-gateway-type-id="<?php echo e($method['gateway_type_id']); ?>"
                                   class="block px-4 py-2 text-sm leading-5 text-gray-700 dropdown-gateway-button hover:bg-gray-100 hover:text-gray-900 focus:outline-none focus:bg-gray-100 focus:text-gray-900"
                                   dusk="payment-method">
                                    <?php echo e(\App\Models\CompanyGateway::find($method['company_gateway_id'])->firstOrFail()->getConfigField('name')); ?>

                                </a>
                            <?php elseif($total > 0): ?>
                                <a href="#" @click="{ open = false }" dusk="pay-with-<?php echo e($index); ?>"
                                   data-company-gateway-id="<?php echo e($method['company_gateway_id']); ?>"
                                   data-gateway-type-id="<?php echo e($method['gateway_type_id']); ?>"
                                   class="block px-4 py-2 text-sm leading-5 text-gray-700 dropdown-gateway-button hover:bg-gray-100 hover:text-gray-900 focus:outline-none focus:bg-gray-100 focus:text-gray-900"
                                   dusk="payment-method">
                                    <?php echo e($method['label']); ?>

                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/unihit/public_html/betaling/resources/views/portal/ninja2020/components/livewire/pay-now-dropdown.blade.php ENDPATH**/ ?>